<?php

App::uses('AppModel', 'Model');

class Option extends AppModel
{
    public function load()
    {
        $options = $this->find('all');

        foreach ($options as $option) {
            Configure::write(
                'Option.' . $option[ 'Option' ][ 'option_name' ],
                $option[ 'Option' ][ 'option_value' ]
            );
        }
    }

    public function beforeSave($options = array())
    {

        if (is_array($this->data[ 'Option' ][ 'option_value' ])) {
            $this->data[ 'Option' ][ 'option_value' ] = serialize($this->data[ 'Option' ][ 'option_value' ]);
        }

        return true;
    }

    public function afterFind($results, $primary = false)
    {

        foreach ($results as $key => $val) {
            if ($this->is_serialized($val[ 'Option' ][ 'option_value' ])) {
                $results[ $key ][ 'Option' ][ 'option_value' ] = unserialize($val[ 'Option' ][ 'option_value' ]);
            }
        }

        return $results;
    }

    // check this if error happened
// https://core.trac.wordpress.org/browser/tags/4.0.1/src/wp-includes/functions.php#L283
    function is_serialized($data)
    {
        if (@unserialize($data) === false) {
            return false;
        } else {
            return true;
        }
    }
}
